% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptionCheck.R
\name{assumptionCheck}
\alias{assumptionCheck}
\title{Assumption Checking Function}
\usage{
assumptionCheck(data, type = c("network", "impact"), percent = 20,
  split = c("median", "mean", "forceEqual", "cutEqual", "quartiles"),
  plot = FALSE, binary.data = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{dataframe or matrix of observational data (rows: observations, columns: nodes)}

\item{type}{which assumptions to check? "network" tests the suitability for
network analysis in general. "impact" tests the suitability for analyzing impact}

\item{percent}{percent difference from grand mean that is acceptable when comparing variances.}

\item{split}{if type="impact", specifies the type of split to utilize}

\item{plot}{logical. Should histograms each variable be plotted?}

\item{binary.data}{logical. Defaults to FALSE}

\item{na.rm}{logical. Should missing values be removed?}
}
\description{
Checks some basic assumptions about the suitability of network analysis on
your data
}
\details{
This function is in BETA. Please report any errors.



Network analysis rests on several assumptions. Among these:
- Variance of each node is (roughly) equal
- Distributions are (roughly) normal

Comparing networks in impact rests on additional assumptions including:
- Overall variances are (roughly) equal in each half

This function checks these assumptions and notifies any violations.
This function is not intended as a substitute for careful data visualization
and independent assumption checks.

See citations in the references section for further details.
}
\references{
Terluin, B., de Boer, M. R., & de Vet, H. C. W. (2016). Differences in Connection Strength between Mental Symptoms Might Be Explained by Differences in Variance: Reanalysis of Network Data Did Not Confirm Staging. PLOS ONE, 11(11), e0155205. Retrieved from https://doi.org/10.1371/journal.pone.0155205
}
