% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.edge.impact}
\alias{plot.edge.impact}
\title{Plot "edge.impact" objects}
\usage{
\method{plot}{edge.impact}(x, nodes = c("first", "all"),
  type.edgeplot = c("contrast", "single"), title = NULL,
  maximum = "auto", ...)
}
\arguments{
\item{x}{an output object from an impact function (\code{edge.impact})}

\item{nodes}{specifies which impact graph(s) to be plotted.
Can be given as a character string of desired node(s) (e.g., c("node1","node2"))
or as a numeric vector of column numbers (e.g., c(1,2)).}

\item{type.edgeplot}{"contrast" returns two separate networks: one for low values of the
given node, and one for high values. "single" returns a network where edges represent
the edge impact of the given node.}

\item{title}{if not otherwise specified, title is automatically generated}

\item{maximum}{sets a maximum for edge thickness (see maximum argument in ?qgraph).
"auto" uses the maximum edge from the collective two networks.}

\item{...}{other plotting specifications (qgraph)}
}
\description{
Convenience function for generating edge impact plots
}
\details{
Inputting a \code{edge.impact} object will return network plots. Depending on the
\code{type.edgeplot} argument, two types of networks are possible. Using "contrast"
will return "true" estimated networks from the data, separated by a median split on the
selected node. Using "single" will return a network where the edges represent the edge
impacts for the selected node (e.g., thick positive edges represent a strong positive
edge impact)
}
