% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_pad.R
\name{zero_pad}
\alias{zero_pad}
\title{Zero pads an image}
\usage{
zero_pad(img, kdim, invert = FALSE, pad_value = 0, ...)
}
\arguments{
\item{img}{Array or class nifti}

\item{kdim}{Dimensions of kernel}

\item{invert}{(logical) If \code{FALSE}, does zero padding.  If \code{TRUE}, 
reverses the process.}

\item{pad_value}{Value to pad the image with.
May use other values, such as -1024 for CT data}

\item{...}{Options to \code{\link{copyNIfTIHeader}}}
}
\value{
Object of class nifti
}
\description{
This function zero pads an image by a certain number of 
dimensions, usually for convolution
}
\examples{
kdim = c(3,3,5)
img = array(rnorm(30*30*36), dim = c(30, 30, 36))
pad = zero_pad(img, kdim)
back = zero_pad(pad, kdim, invert=TRUE)
all.equal(back, img)
}
