% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/same_dims.R
\name{same_dims}
\alias{same_dims}
\title{Check if Objects have Same Dimensions}
\usage{
same_dims(...)
}
\arguments{
\item{...}{Arguments (matrices or arrays) where the dimension will be 
checked against the first object's dimension}
}
\value{
Logical indicating if all have the same dimensions or not
}
\description{
Wrapper to check if multiple objects all have the 
same dimensions
}
\examples{
mat1 = matrix(1:9, ncol = 3)
mat2 = matrix(rnorm(9), ncol = 3)
mat3 = matrix(rnorm(16), ncol = 4)
mat4 = matrix(rnorm(9), ncol = 3)
same_dims(mat1, mat2)
same_dims(mat1, mat3)
same_dims(mat1, mat2, mat4)
}
