% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{aggregate}
\alias{aggregate}
\alias{aggregate,CompositionMatrix-method}
\title{Compute Summary Statistics of Data Subsets}
\usage{
\S4method{aggregate}{CompositionMatrix}(x, by, FUN, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{by}{A \code{\link{character}} string specifying the grouping element. It must be
one of "\code{samples}" or "\code{groups}". Any unambiguous substring can be given.}

\item{FUN}{A \code{\link{function}} to compute the summary statistics.}

\item{...}{Further arguments to be passed to \code{FUN}.}
}
\value{
A \code{\link{matrix}}.
}
\description{
Splits the data into subsets, computes summary statistics for each, and
returns the result.
}
\examples{
## Create a data.frame
X <- data.frame(
  samples = c("A", "A", "A", "B", "B", "B", "C", "C", "C"),
  groups = c("X", "X", "X", "X", "X", "X", "Y", "Y", "Y"),
  Ca = c(7.72, 7.32, 3.11, 7.19, 7.41, 5, 4.18, 1, 4.51),
  Fe = c(6.12, 5.88, 5.12, 6.18, 6.02, 7.14, 5.25, 5.28, 5.72),
  Na = c(0.97, 1.59, 1.25, 0.86, 0.76, 0.51, 0.75, 0.52, 0.56)
)

## Coerce to a compositional matrix
Y <- as_composition(X)

## Compositional mean by sample
aggregate(Y, by = "samples", FUN = mean)

## Metric variance by group
aggregate(Y, by = "groups", FUN = metric_var)
}
\seealso{
Other statistics: 
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{metric_var}()},
\code{\link{scale}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
