% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/condense.R
\docType{methods}
\name{condense}
\alias{condense}
\alias{condense-method}
\alias{condense,CompositionMatrix-method}
\title{Compositional Mean of Data Subsets}
\usage{
condense(x, ...)

\S4method{condense}{CompositionMatrix}(x, by = groups(x), ...)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further arguments to be passed to \code{\link[=mean]{mean()}}.}

\item{by}{A \code{vector} or a list of grouping elements, each as long as the
variables in \code{x}. The elements are coerced to factors before use
(in the sense that \code{\link[=interaction]{interaction(by)}} defines the grouping).}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Splits the data into subsets and computes compositional mean for each.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to a compositional matrix
coda <- as_composition(slides, groups = 2)

## Compositional mean by group
condense(coda)
}
\seealso{
\code{\link[=mean]{mean()}}, \code{\link[=aggregate]{aggregate()}}

Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
