% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hist.R
\docType{methods}
\name{hist}
\alias{hist}
\alias{hist,CompositionMatrix-method}
\title{Histogram of Compositional Data}
\usage{
\S4method{hist}{CompositionMatrix}(
  x,
  ...,
  freq = FALSE,
  ncol = NULL,
  flip = FALSE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes
)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further parameters to be passed to \code{\link[graphics:hist]{graphics::hist()}}.}

\item{freq}{A \code{\link{logical}} scalar: should absolute frequencies (counts) be
displayed? If \code{FALSE} (the default), relative frequencies (probabilities)
are displayed (see \code{\link[graphics:hist]{graphics::hist()}}).}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use.
Defaults to 1 for up to 4 parts, otherwise to 2.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from variable to variable?}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}
}
\value{
\code{hist()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Produces an histogram of univariate ILR data (see Filzmoser \emph{et al.}, 2009).
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Boxplot plot
hist(coda)
hist(coda[, 1, drop = FALSE])

univariate_ilr(coda)
}
\references{
Filzmoser, P., Hron, K. & Reimann, C. (2009). Univariate Statistical
Analysis of Environmental (Compositional) Data: Problems and Possibilities.
\emph{Science of The Total Environment}, 407(23): 6100-6108.
\doi{10.1016/j.scitotenv.2009.08.008}.
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{plot}()},
\code{\link{plot_logratio}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
