% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/simplex.R
\docType{methods}
\name{scalar}
\alias{scalar}
\alias{scalar-method}
\alias{scalar,numeric,numeric-method}
\alias{scalar,CompositionMatrix,CompositionMatrix-method}
\title{Scalar Product}
\usage{
scalar(x, y, ...)

\S4method{scalar}{numeric,numeric}(x, y)

\S4method{scalar}{CompositionMatrix,CompositionMatrix}(x, y)
}
\arguments{
\item{x, y}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Computes the Aitchison scalar product of two compositions.
}
\examples{
x <- as_composition(c(1, 2, 3))
y <- as_composition(c(1, 2, 1))

## Perturbation
perturbation(x, y)
x + y

## Powering
powering(y, 2)
y * 2

## Scalar product
scalar(x, y)
}
\seealso{
Other operations in the simplex: 
\code{\link{arithmetic}},
\code{\link{closure}()},
\code{\link{perturbation}()},
\code{\link{powering}()}
}
\author{
N. Frerebeau
}
\concept{operations in the simplex}
