% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_nfl.R
\name{gt_nfl_headshots}
\alias{gt_nfl_headshots}
\title{Render Player Headshots in 'gt' Tables}
\usage{
gt_nfl_headshots(gt_object, columns, height = 30, locations = NULL)
}
\arguments{
\item{gt_object}{A table object that is created using the \code{\link[gt:gt]{gt::gt()}} function.}

\item{columns}{The columns for which the image translation should be applied.
Argument has no effect if \code{locations} is not \code{NULL}.}

\item{height}{The absolute height (px) of the image in the table cell.}

\item{locations}{If \code{NULL} (the default), the function will render
logos/wordmarks in argument \code{columns}.
Otherwise, the cell or set of cells to be associated with the team name
transformation. Only the \code{\link[gt:cells_body]{gt::cells_body()}}, \code{\link[gt:cells_stub]{gt::cells_stub()}},
\code{\link[gt:cells_column_labels]{gt::cells_column_labels()}}, and \code{\link[gt:cells_row_groups]{gt::cells_row_groups()}} helper functions
can be used here. We can enclose several of these calls within a \code{list()}
if we wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Translate NFL player gsis IDs to player headshots and
render these images in html tables with the 'gt' package.
}
\section{Output of below example}{

\if{html}{\figure{headshot_tbl.png}{options: width=50\%}}
}

\examples{
\donttest{
library(nflplotR)
library(gt)
# Silence an nflreadr message that is irrelevant here
old <- options(nflreadr.cache_warning = FALSE)
df <- data.frame(
  player_gsis = c("00-0033873",
                  "00-0026498",
                  "00-0035228",
                  "00-0031237",
                  "00-0036355",
                  "00-0019596",
                  "00-0033077",
                  "00-0012345",
                  "00-0031280"),
  player_name = c("P.Mahomes",
                  "M.Stafford",
                  "K.Murray",
                  "T.Bridgewater",
                  "J.Herbert",
                  "T.Brady",
                  "D.Prescott",
                  "Non.Match",
                  "D.Carr")
)

# Replace player IDs with headshot images
table <- gt(df) \%>\%
  gt_nfl_headshots("player_gsis")

# Restore old options
options(old)
}
}
\seealso{
The logo and wordmark rendering functions \code{\link[=gt_nfl_logos]{gt_nfl_logos()}} and
\code{\link[=gt_nfl_wordmarks]{gt_nfl_wordmarks()}}.
}
