% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_codebook.R
\name{nhanesCodebook}
\alias{nhanesCodebook}
\title{Display codebook for selected variable.}
\usage{
nhanesCodebook(nh_table, colname = NULL, dxa = FALSE)
}
\arguments{
\item{nh_table}{The name of the NHANES table that contains the desired variable.}

\item{colname}{The name of the table column (variable).}

\item{dxa}{If TRUE then the 2005-2006 DXA codebook will be used (default=FALSE).}
}
\value{
The codebook is returned as a list object. Returns NULL upon error.
}
\description{
Returns full NHANES codebook including Variable Name, SAS Label, English Text, Target,
and Value distribution.
}
\details{
Each NHANES variable has a codebook that provides a basic
  description as well as the distribution or range of values. This
  function returns the full codebook information for the selected
  variable. If the environment variable \code{NHANES_TABLE_BASE}
  was set during startup, the value of this variable is used as the
  base URL instead of \url{https://wwwn.cdc.gov} (this allows the
  use of a local or alternative mirror of the CDC documentation).
}
\examples{
\donttest{nhanesCodebook('AUX_D', 'AUQ020D')}
\donttest{nhanesCodebook('BPX_J', 'BPACSZ')}
\donttest{bpx_code = nhanesCodebook('BPX_J')}
\donttest{length(bpx_code)}
}
