% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTableSummary}
\alias{nhanesTableSummary}
\title{Summarize NHANES table}
\usage{
nhanesTableSummary(nh_table, use = c("data", "codebook", "both"), ...)
}
\arguments{
\item{nh_table}{the name of a valid NHANES table}

\item{use}{character string, whether to create a summary from the
data itself or the codebook, which respectively use either the
NHANES SAS data files or the HTML documentation files. If
\code{use = "both"} then both are computed as merged; the
\code{src} and \code{...} arguments are ignored in this case.}

\item{...}{additional arguments, usually passed on to either
\code{\link{nhanes}} or \code{\link{nhanesCodebook}} as
appropriate. Alternatively, the \code{src} argument can be used
to pass on an already available data frame or codebook, but this
must be consistent with the \code{use} argument.}
}
\value{
A data frame with one row per variable, with columns
  depending on the value of the \code{use} argument.
}
\description{
Summarize a NHANES table
}
\details{
Returns a per-variable summary of a NHANES table either using the
actual data or its corresponding codebook
}
\examples{
\donttest{nhanesTableSummary('DEMO_D', use = "data")}
\donttest{nhanesTableSummary('DEMO_D', use = "codebook")}
}
