% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{nhd_load}
\alias{nhd_load}
\title{Load NHD layers into current session}
\usage{
nhd_load(state, dsn, file_ext = NA, approve_all_dl = FALSE, ...)
}
\arguments{
\item{state}{character state abbreviation}

\item{dsn}{character name of a NHD layer}

\item{file_ext}{character choice of "shp" for spatial data and
"dbf" or "gpkg" for non-spatial. optional}

\item{approve_all_dl}{logical blanket approval to download all missing data. Defaults to TRUE if sesson is non-interactive.}

\item{...}{arguments passed to sf::st_read}
}
\value{
Spatial simple features object or data frame depending on the dsn
type and value passed to file_ext
}
\description{
Load NHD layers into current session
}
\details{
This function will ask the user to approve downloading missing data
 unless approve_all_dl is set to TRUE.
}
\examples{
\dontrun{
dt <- nhd_load(c("RI"), c("NHDWaterbody"))
dt <- nhd_load(c("CT", "RI"), "NHDWaterbody")
dt <- nhd_load(c("CT", "RI"), "NHDWaterbody", quiet = TRUE)
dt <- nhd_load("MI", "NHDFlowline")
dt <- nhd_load("RI", "NHDReachCrossReference")
dt <- nhd_load("RI", "NHDWaterbody", file_ext = "dbf")
dt <- nhd_load(c("RI", "DC"), "NHDWaterbody", file_ext = "gpkg")
}
}
