% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_nhdplus.R
\name{subset_rpu}
\alias{subset_rpu}
\title{Subset by Raster Processing Unit}
\usage{
subset_rpu(fline, rpu, run_make_standalone = TRUE, strict = FALSE)
}
\arguments{
\item{fline}{sf data.frame NHD Flowlines with comid, pathlength, lengthkm,
hydroseq, levelpathi, rpuid, and arbolatesu (dnhydroseq
is required if tocomid is not provided).}

\item{rpu}{character e.g. "01a"}

\item{run_make_standalone}{logical default TRUE
should the run_make_standalone function be run on result?}

\item{strict}{logical if TRUE, paths that extend outside the RPU but
have no tributaries in the upstream RPU will be included in the output.}
}
\value{
data.frame containing subset network
}
\description{
Given flowlines and an rpu_code, performs a network-safe subset such
that the result can be used in downstream processing. Has been tested to work
against the entire NHDPlusV2 domain and satisfies a number of edge cases.
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

sample_flines <- sf::read_sf(sample_data, "NHDFlowline_Network")

subset_rpu(sample_flines, rpu = "07b")

}
