% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{nhds_adult}
\alias{nhds_adult}
\alias{nhds_adults}
\alias{nhds_pediatric}
\alias{nhds_peds}
\alias{nhds_neonatal}
\alias{nhds_neonatal_not_newborn}
\alias{nhds_neonate_not_newborn}
\alias{nhds_neonate}
\alias{nhds_infant}
\alias{nhds_infant_not_neonate}
\alias{nhds_newborn}
\alias{nhds_newborns}
\title{Return adult, pediatric or just neonatal elements from the NHDS data}
\usage{
nhds_adult(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_adults(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_pediatric(nhds_data = nhds::nhds2010)

nhds_peds(nhds_data = nhds::nhds2010)

nhds_neonatal(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_neonatal_not_newborn(nhds_data = nhds::nhds2010,
  rename_age = TRUE)

nhds_neonate_not_newborn(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_neonate(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_infant(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_infant_not_neonate(nhds_data = nhds::nhds2010, rename_age = TRUE)

nhds_newborn(nhds_data = nhds::nhds2010)

nhds_newborns(nhds_data = nhds::nhds2010)
}
\arguments{
\item{nhds_data}{The NHDS data, default is `nhds2010`, which is the only year
currently provided by this package.}

\item{rename_age}{Logical, if `TRUE`, the default, the `age` field is renamed
to either `age_days` (for neonatal data) or `age_years` (for adult data).}
}
\description{
The age in the adult data is all specified in years, so the `age_unit` column
is dropped. The `age_unit` field is retained when returning pediatric data.
}
\section{Neonates and newborns}{


  For newborns, when the `newborn` field is `TRUE`, the `age` is always zero
  at time of admission, so `age` and `age_unit` are dropped. This must
  therefore refer to birth in hospital, not an admission of a neonate who is
  transferred. For the same reason, `adm_type` is dropped because it is
  always `newborn`.

  In contrast, neonatal data includes both in-hospital births and admissions
  of patients with age 28 or fewer days. Strangely, `marital_status` is
  populated with a variety of values for the neonatal data, but all `newborn`
  babies are considered `single`, so that field is dropped by `nhds_newborn`.
}

\examples{
head(nhds_adult())
# subset returned data directly
nhds_pediatric()[11:20, c("age_unit", "age")]
nhds_pediatric()[1:5, 1:7]
nhds_infant()[111:115, 1:7]
nhds_infant_not_neonate()[1:5, 1:7]
nhds_neonatal()[1:5, 1:7]
nhds_neonatal_not_newborn()[1:5, 1:7]
identical(nhds_neonatal()[1:10, ],
          nhds_neonate()[1:10, ])
identical(nhds_neonatal_not_newborn()[1:10, ],
          nhds_neonate_not_newborn()[1:10, ])
nhds_newborn()[1:5, 1:7]
}
