% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_standings.R
\name{nhl_standings}
\alias{nhl_standings}
\title{Retrieve metadata on NHL standings from the API}
\usage{
nhl_standings(seasons = NULL, standingsTypes = NULL, expand = NULL)
}
\arguments{
\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}

\item{standingsTypes}{\code{character()}, defining the standings
types to retrieve. Valid standings types are for example
\code{"regularSeason"} or \code{"byDivision"}. See
\code{\link[=nhl_md_standings_types]{nhl_md_standings_types()}} for all values and their
descriptions.}

\item{expand}{\code{character()}, of parameters passed as \code{expand}
to the API URL. A valid example seems to be \code{"standings.record"}.
\code{NULL} for no expand parameter.}
}
\value{
\code{list}, with information on standings
depending on provided arguments.
}
\description{
Retrieve metadata on NHL standings from the API
}
\examples{
\dontrun{
 # Get current standings
 nhl_standings()

 # Get standings for historical seasons
 nhl_standings(seasons = 2015:2016)

 # Get standings for historical seasons
 nhl_standings(
   seasons = 2015:2016,
   standingsType = "byDivision",
   expand = "standings.record"
 )
}

}
