% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_players.R
\name{nhl_players}
\alias{nhl_players}
\title{Retrieve metadata for players based on names or ids}
\usage{
nhl_players(playerNames, playerIds = NULL)
}
\arguments{
\item{playerNames}{\code{character()}, vector of one or more player names.
Not case sensitive for convenience.}

\item{playerIds}{\code{integer()}, vector of one or more ids of the
players. The ids correspond to the ids expected by the NHL
API people endpoint. For most cases the \code{playerNames} argument
can be provided for more convenient usage.}
}
\value{
\code{data.frame}, with information on selected players.
}
\description{
Retrieves information on players from the NHL API based on
\code{playerNames} or \code{playerIds}. If \code{playerNames} are provided,
they take precedence over \code{playerIds}.
}
\examples{
\dontrun{
 # With player names
 nhl_players(c("joe SAKIC", "patrick roy"))

 # With playerIds
 nhl_players(playerIds = c(8451101, 8458554))
}
}
