% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helpers.R
\name{niche_legend}
\alias{niche_legend}
\title{Legends for niche labels in phylogenetic trees}
\usage{
niche_legend(position, legend = c("Uncertain", "Present", "Not present"),
  pch = 22, pt.bg = c("#969696", "#e41a1c", "#377eb8"),
  col = "transparent", pt.cex = 2.2, bty = "n", ...)
}
\arguments{
\item{position}{(character or numeric) position of legend. If character,
part of the plot (e.g., "topleft"), see \code{\link[graphics]{legend}}. If
numeric, vector of two values indicating x and y position (e.g., c(0.1, 6)).}

\item{legend}{(character) vector of length = three indicating the text to
identify environments with uncertain presence, presence, and absence of the
species. Default = c("Uncertain", "Present", "Not present").}

\item{pch}{point type as in \code{\link[graphics]{points}}. Default = 22.}

\item{pt.bg}{colors to represent what is in \code{legend}.
Default = c("#969696", "#e41a1c", "#377eb8").}

\item{col}{border of symbol (points). Default = "transparent".}

\item{pt.cex}{size of symbol (points). Default = 2.2.}

\item{bty}{legend border type. Default = "n".}

\item{...}{Other arguments from function \code{\link[graphics]{legend}} other
than the ones described above.}
}
\description{
Legends for niche labels in phylogenetic trees
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum parsimony reconstruction
rec_tab <- smooth_rec(bin_par_rec(treeWdata))

# plotting and adding labels and legend
ape::plot.phylo(tree5, label.offset = 0.04)
niche_labels(tree5, rec_tab, height = 0.6)
niche_legend(position = "topleft", cex = 0.7)
}
