% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{CAR-Proper}
\alias{CAR-Proper}
\alias{dcar_proper}
\alias{rcar_proper}
\title{The CAR-Proper Distribution}
\usage{
dcar_proper(x, mu, C = CAR_calcC(adj, num), adj, num, M = CAR_calcM(num),
  tau, gamma, evs = CAR_calcEVs3(C, adj, num), log = FALSE)

rcar_proper(n = 1, mu, C = CAR_calcC(adj, num), adj, num,
  M = CAR_calcM(num), tau, gamma, evs = CAR_calcEVs3(C, adj, num))
}
\arguments{
\item{x}{vector of values.}

\item{mu}{vector of the same length as \code{x}, specifying the mean for each spatial location.}

\item{C}{vector of the same length as \code{adj}, giving the weights associated with each pair of neighboring locations.  See \sQuote{Details}.}

\item{adj}{vector of indices of the adjacent locations (neighbors) of each spatial location.  This is a sparse representation of the full adjacency matrix.}

\item{num}{vector giving the number of neighboring locations of each spatial location, with length equal to the number of locations.}

\item{M}{vector giving the diagonal elements of the conditional variance matrix, with length equal to the number of locations.  See \sQuote{Details}.}

\item{tau}{scalar precision of the Gaussian CAR prior.}

\item{gamma}{scalar representing the overall degree of spatial dependence.  See \sQuote{Details}.}

\item{evs}{vector of eigenvalues of the adjacency matrix implied by \code{C}, \code{adj}, and \code{num}.  This parameter should not be provided; it will always be calculated using the adjacency information.}

\item{log}{logical; if \code{TRUE}, probability density is returned on the log scale.}

\item{n}{number of observations.}
}
\value{
\code{dcar_proper} gives the density, and \code{rcar_proper} generates random deviates.
}
\description{
Density function and random generation for the proper
  Gaussian conditional autoregressive (CAR) distribution.
}
\details{
If both \code{C} and \code{M} are omitted, then all weights are taken as one, and corresponding values of \code{C} and \code{M} are generated.

The \code{C} and \code{M} parameters must jointly satisfy a symmetry constraint: that \code{M^(-1) \%*\% C} is symmetric, where \code{M} is a diagonal matrix and \code{C} is the full weight matrix that is sparsely represented by the parameter vector \code{C}.

For a proper CAR model, the value of \code{gamma} must lie within the inverse minimum and maximum eigenvalues of \code{M^(-0.5) \%*\% C \%*\% M^(0.5)}, where \code{M} is a diagonal matrix and \code{C} is the full weight matrix.  These bounds can be calculated using the deterministic functions \code{carMinBound(C, adj, num, M)} and \code{carMaxBound(C, adj, num, M)}, or simultaneously using \code{carBounds(C, adj, num, M)}.  In the case where \code{C} and \code{M} are omitted (all weights equal to one), the bounds on gamma are necessarily (-1, 1).
}
\examples{

x <- c(1, 3, 3, 4)
mu <- rep(3, 4)
adj <- c(2, 1,3, 2,4, 3)
num <- c(1, 2, 2, 1)
 
## omitting C and M uses all weights = 1
dcar_proper(x, mu, adj = adj, num = num, tau = 1, gamma = 0.95)
 
## equivalent to above: specifying all weights = 1,
## then using as.carCM to generate C and M arguments
weights <- rep(1, 6)
CM <- as.carCM(adj, weights, num)
C <- CM$C
M <- CM$M
dcar_proper(x, mu, C, adj, num, M, tau = 1, gamma = 0.95)
 
## now using non-unit weights
weights <- c(2, 2, 3, 3, 4, 4)
CM2 <- as.carCM(adj, weights, num)
C2 <- CM2$C
M2 <- CM2$M
dcar_proper(x, mu, C2, adj, num, M2, tau = 1, gamma = 0.95)
}
\author{
Daniel Turek
}
\references{
Banerjee, S., Carlin, B.P., and Gelfand, A.E. (2015). \emph{Hierarchical Modeling and Analysis for Spatial Data}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{CAR-Normal}, \link{Distributions} for other standard distributions
}

