% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dDoubleExponentialGrowth.R
\name{dDoubleExponentialGrowth}
\alias{dDoubleExponentialGrowth}
\alias{rDoubleExponentialGrowth}
\title{Double Exponential Growth Model}
\usage{
dDoubleExponentialGrowth(x, a, b, r1, r2, mu, log)

rDoubleExponentialGrowth(n, a, b, r1, r2, mu)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{r1}{growth rate before change point mu.}

\item{r2}{growth rate after change point mu.}

\item{mu}{change point (in BP).}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dDoubleExponentialGrowth}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rDoubleExponentialGrowth} a simulated date in Cal BP.
}
\description{
Density and random generation of an exponential growth model distribution.
}
\examples{
p = list(r1=0.003,r2=-0.001,mu=5200)
modelPlot(model = dDoubleExponentialGrowth,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Enrico Crema
}
