% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageChildren.R
\name{ageChildren}
\alias{ageChildren}
\title{Goodness of fit to an expected (model-based) age distribution}
\usage{
ageChildren(
  age,
  u5mr = 0,
  groups = "6:17=1; 18:29=2; 30:41=3; 42:53=4; 54:59=5"
)
}
\arguments{
\item{age}{Vector of ages}

\item{u5mr}{Under five years mortality rate as deaths / 10,000 persons / day}

\item{groups}{Age groupings specified as recodes parameter in the
\code{\link[bbw:recode]{bbw::recode()}} function; default is
\code{"6:17=1; 18:29=2; 30:41=3; 42:53=4; 54:59=5"}}
}
\value{
A list of class "ageChildren" with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{u5mr} \tab Under five years mortality rate as deaths / 10000 persons / day \cr
   \emph{observed} \tab Table of counts in each (year-centred) age group \cr
   \emph{expected} \tab Table of expected counts in each (year-centred) age group \cr
   \emph{X2} \tab Chi-squared test statistic \cr
   \emph{df} \tab Degrees of freedom for Chi-squared test \cr
   \emph{p} \tab p-value for Chi-squared test \cr
}
}
\description{
Goodness of fit to an expected (model-based) age distribution
}
\examples{
# Chi-Squared test for age of children in dp.ex02 sample dataset using an
# u5mr of 1 / 10,000 / day.
svy <- dp.ex02
ac <- ageChildren(svy$age, u5mr = 1)
ac

# Apply function to each sex separately
# Males
acM <- ageChildren(svy$age[svy$sex == 1], u5mr = 1)
acM
# Females
acF <- ageChildren(svy$age[svy$sex == 2], u5mr = 1)

# Simplified call to function by sex
by(svy$age, svy$sex, ageChildren, u5mr = 1)

}
