% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageRatioTest.R
\name{ageRatioTest}
\alias{ageRatioTest}
\title{Age ratio test}
\usage{
ageRatioTest(x, ratio = 0.85)
}
\arguments{
\item{x}{Numeric vector (age)}

\item{ratio}{Expected age ratio}
}
\value{
A lit of class \code{"ageRatioTest"} with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{expectedR} \tab Expected sex ratio \cr
   \emph{expectedP} \tab Expected proportion aged 6:29 months \cr
   \emph{observedR} \tab Observed sex ratio \cr
   \emph{observedP} \tab Observed proportion aged 6:29 months \cr
   \emph{X2} \tab Chi-squared test statistic \cr
   \emph{df} \tab Degrees of freedom for Chi-squared test \cr
   \emph{p} \tab \code{p-value} for Chi-squared test \cr
}
}
\description{
Age Ratio Test is an age-related test of survey and data quality.
}
\examples{
# Age-ratio test on survey dataset from Kabul, Afghanistan (dp.ex02)
# with an age ratio of 0.85
svy <- dp.ex02
ageRatioTest(svy$age, ratio = 0.85)

# The age ratio test applied to data for each sex separately
by(svy$age, svy$sex, ageRatioTest, ratio = 0.85)

}
