% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxText.R
\name{boxText}
\alias{boxText}
\title{Plot text in a coloured bounding box.}
\usage{
boxText(
  x,
  y,
  labels,
  cex = 0.75,
  col = "white",
  border = FALSE,
  lwd = 0.5,
  pad = TRUE
)
}
\arguments{
\item{x, y}{Co-ordinates of text that is to be plotted}

\item{labels}{Text to be plotted}

\item{cex}{Character expansion}

\item{col}{Background colour}

\item{border}{Border colour}

\item{lwd}{Border width}

\item{pad}{Add padding to (L) and (R) ends of bounding box}
}
\description{
Plot text in a coloured bounding box.
}
\examples{
## Use of boxtext in the ageHeaping plot function
svy <- dp.ex02
ah12 <- ageHeaping(svy$age)

plot.new()
boxText(x = as.numeric(names(ah12$tab)),
        y = max(ah12$tab) * 0.1,
        labels = paste(sprintf(fmt = "\%3.1f", ah12$pct), "\%", sep = ""),
        cex = 0.5,
        pad = TRUE)

}
