% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pwr.R
\name{Pwr}
\alias{Pwr}
\title{Calculates power based on a model fit}
\usage{
Pwr(object, ...)
}
\arguments{
\item{object}{an object containing the results returned by a model fitting function (e.g., \code{\link[nlme:lme]{lme}}).}

\item{\dots}{some methods for this generic function may require additional arguments.}
}
\value{
Numeric scalar value.
}
\description{
This function is generic; method functions can be written to handle specific classes of objects.
}
\examples{
\dontrun{
  library(nlme)
  fm1 <- lme(distance ~ age, data = Orthodont)
  Pwr(fm1)
}
}
\references{
Galecki, A., & Burzykowski, T. (2013). *Linear Mixed-Effects Models: A Step-by-Step Approach*. Springer.
}
\seealso{
\code{\link{Pwr.lme}}
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
