% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varia.R
\name{missPat}
\alias{missPat}
\title{Extract pattern of missing data}
\usage{
missPat(..., symbols = c("X", "-"), collapse = "", missData = FALSE)
}
\arguments{
\item{\dots}{one or more vectors, matrices, or data frames, compatible for column-wise binding.}

\item{symbols}{vector containing two single characters used to indicate \code{NA} and non-\code{NA} values. By default, \code{c("X", "-")}.}

\item{collapse}{an optional character string used in the internal call to \code{paste()} to separate results. By default, \code{""}.}

\item{missData}{logical. If \code{TRUE}, a data frame with the pattern of missing values is saved in the \code{missData} attribute of the returned vector. By default, \code{FALSE}.}
}
\value{
Character vector with as many elements as the length of vector(s) or number of rows in matrices/data frames in \code{\dots}. 
  Attribute \code{cnames} contains names of vectors/columns/variables. 
  Optional attribute \code{missData} contains a data frame with the missing pattern.
}
\description{
This function compactly presents the pattern of missing data in a given vector, matrix, or data frame.
}
\examples{
\dontrun{
  data(armd.wide, package = "nlmeU")
  dtf <- armd.wide[ , c("visual12", "visual24", "visual52")]
  missPat(dtf, symbols = c("?", "+"))
}
}
\seealso{
\code{\link{armd.wide}}
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
