% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foceiFit.R
\name{foceiControl}
\alias{foceiControl}
\title{Control Options for FOCEi}
\usage{
foceiControl(sigdig = 4, epsilon = NULL, maxInnerIterations = 1000,
  maxOuterIterations = 5000, n1qn1nsim = NULL, method = c("liblsoda",
  "lsoda", "dop853"), transitAbs = NULL, atol = NULL, rtol = NULL,
  maxstepsOde = 5000L, hmin = 0L, hmax = NULL, hini = 0,
  maxordn = 12L, maxords = 5L, cores, covsInterpolation = c("locf",
  "linear", "nocb", "midpoint"), printInner = 0L, print = 1L,
  printNcol = floor((getOption("width") - 23)/12), scaleTo = 1,
  scaleObjective = 1, derivEps = rep(20 * sqrt(.Machine$double.eps),
  2), derivMethod = c("switch", "forward", "central"),
  derivSwitchTol = NULL, covDerivMethod = c("central", "forward"),
  covMethod = c("r,s", "r", "s", ""), hessEps = 0.001,
  covDerivEps = c(0, 0.001), lbfgsLmm = 7L, lbfgsPgtol = 0,
  lbfgsFactr = NULL, eigen = TRUE, addPosthoc = TRUE,
  diagXform = c("sqrt", "log", "identity"), sumProd = FALSE,
  optExpression = TRUE, ci = 0.95, useColor = crayon::has_color(),
  boundTol = NULL, calcTables = TRUE, noAbort = TRUE,
  interaction = TRUE, cholSEtol = (.Machine$double.eps)^(1/3),
  cholAccept = 0.001, resetEtaP = 0.1, diagOmegaBoundUpper = 5,
  diagOmegaBoundLower = 100, cholSEOpt = FALSE, cholSECov = FALSE,
  fo = FALSE, covTryHarder = FALSE, outerOpt = c("bobyqa",
  "L-BFGS-B", "lbfgsb3", "nlminb", "mma", "lbfgsbLG", "slsqp"),
  innerOpt = c("n1qn1", "BFGS"), rhobeg = 0.2, rhoend = NULL,
  npt = NULL, rel.tol = NULL, x.tol = NULL, eval.max = 4000,
  iter.max = 2000, abstol = NULL, reltol = NULL,
  resetHessianAndEta = FALSE, stateTrim = Inf, ..., stiff)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is \code{10^(-sigdig-1)}

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

 \item The significant figures that some tables are rounded to.
}}

\item{epsilon}{Precision of estimate for n1qn1 optimization.}

\item{maxInnerIterations}{Number of iterations for n1qn1
optimization.}

\item{maxOuterIterations}{Maximum number of L-BFGS-B optimization
for outer problem.}

\item{n1qn1nsim}{Number of function evaluations for n1qn1
optimization.}

\item{method}{The method for solving ODEs.  Currently this supports:

\itemize{
\item \code{"liblsoda"} thread safe lsoda.  This supports parallel
           thread-based solving, and ignores user Jacobian specification.
\item \code{"lsoda"} -- LSODA solver.  Does not support parallel thread-based
      solving, but allows user Jacobian specification.
\item \code{"dop853"} -- DOP853 solver.  Does not support parallel thread-based
        solving nor user Jacobain specification
}}

\item{transitAbs}{boolean indicating if this is a transit
compartment absorption}

\item{atol}{a numeric absolute tolerance (1e-8 by default) used
by the ODE solver to determine if a good solution has been
achieved;  This is also used in the solved linear model to check
if prior doses do not add anything to the solution.}

\item{rtol}{a numeric relative tolerance (1e-6 by default) used
by the ODE solver to determine if a good solution has been
achieved. This is also used in the solved linear model to check
 if prior doses do not add anything to the solution.}

\item{maxstepsOde}{Maximum number of steps for ODE solver.}

\item{hmin}{The minimum absolute step size allowed. The default
value is 0.}

\item{hmax}{The maximum absolute step size allowed.  The default
checks for the maximum difference in times in your sampling and
events, and uses this value.  The value 0 is equivalent to
infinite maximum absolute step size.}

\item{hini}{The step size to be attempted on the first step. The
default value is determined by the solver (when hini = 0)}

\item{maxordn}{The maximum order to be allowed for the nonstiff
(Adams) method.  The default is 12.  It can be between 1 and
12.}

\item{maxords}{The maximum order to be allowed for the stiff (BDF)
method.  The default value is 5.  This can be between 1 and 5.}

\item{cores}{Number of cores used in parallel ODE solving.  This
defaults to the number or system cores determined by
\code{\link{rxCores}} for methods that support parallel
solving (ie thread-safe methods like "liblsoda").}

\item{covsInterpolation}{specifies the interpolation method for
    time-varying covariates. When solving ODEs it often samples
    times outside the sampling time specified in \code{events}.
    When this happens, the time varying covariates are
    interpolated.  Currently this can be:

\itemize{
\item \code{"linear"} interpolation (the default), which interpolates the covariate
    by solving the line between the observed covariates and extrapolating the new
    covariate value.
\item \code{"constant"} -- Last observation carried forward.
\item \code{"NOCB"} -- Next Observation Carried Backward.  This is the same method
      that NONMEM uses.
\item \code{"midpoint"} Last observation carried forward to midpoint; Next observation
  carried backward to midpoint.
}}

\item{printInner}{Integer representing when the inner step is
printed. By default this is 0 or do not print.  1 is print
every function evaluation, 5 is print every 5 evaluations.}

\item{print}{Integer representing when the outer step is
printed. When this is 0 or do not print the iterations.  1 is
print every function evaluation (default), 5 is print every 5
evaluations.}

\item{printNcol}{Number of columns to printout before wrapping
parameter estimates/gradient}

\item{scaleTo}{Scale the initial parameter estimate to this value.
By default this is 1.  When zero or below, no scaling is performed.}

\item{scaleObjective}{Scale the initial objective function to this
    value.  By default this is 1.  When \code{scaleObjective} is
    greater than zero, this scaling is performed by:

     \code{scaledObj = currentObj / \|initialObj\| * scaleObjective}

    Therefore, if the initial objective function is negative, the
    initial scaled objective function would be negative as well.
    When \code{scaleObjective} is less than zero, no scaling is
    performed.}

\item{derivEps}{Central/Forward difference tolerances, which is a
    vector of relative difference and absolute difference.  The
    central/forward difference step size h is calculated as:

        \code{h = abs(x)*derivEps[1] + derivEps[2]}}

\item{derivMethod}{indicates the method for calculating
derivatives of the outer problem.  Currently supports
"switch", "central" and "forward" difference methods.  Switch
starts with forward differences.  This will switch to central
differences when abs(delta(OFV)) <= derivSwitchTol and switch
back to forward differences when abs(delta(OFV)) >
derivSwitchTol.}

\item{derivSwitchTol}{The tolerance to switch forward to central
differences.}

\item{covDerivMethod}{indicates the method for calculating the
derivatives while calculating the covariance components
(Hessian and S).}

\item{covMethod}{Method for calculating covariance.  In this
    discussion, R is the Hessian matrix of the objective
    function. The S matrix is the sum of individual
    gradient cross-product (evaluated at the individual empirical
    Bayes estimates).

\itemize{

 \item "\code{r,s}" Uses the sandwich matrix to calculate the covariance, that is: \code{solve(R) \%*\% S \%*\% solve(R)}

 \item "\code{r}" Uses the Hessian matrix to calculate the covariance as \code{2 \%*\% solve(R)}

 \item "\code{s}" Uses the crossproduct matrix to calculate the covariance as \code{4 \%*\% solve(S)}

 \item "" Does not calculate the covariance step.
}}

\item{hessEps}{is a double value representing the epsilon for the Hessian calculation.}

\item{covDerivEps}{Central/Forward difference tolerances while
    calculating the covariance matrices.  This is a numeric vector
    of relative difference and absolute difference.  The
    central/forward difference step size h is calculated as:

        \code{h = abs(x)*derivEps[1] + derivEps[2]}}

\item{lbfgsLmm}{An integer giving the number of BFGS updates
retained in the "L-BFGS-B" method, It defaults to 7.}

\item{lbfgsPgtol}{is a double precision variable.

    On entry pgtol >= 0 is specified by the user.  The iteration
    will stop when:

       \code{max(\| proj g_i \| i = 1, ..., n) <= lbfgsPgtol}

    where pg_i is the ith component of the projected gradient.

    On exit pgtol is unchanged.  This defaults to zero, when the
    check is suppressed.}

\item{lbfgsFactr}{Controls the convergence of the "L-BFGS-B"
method.  Convergence occurs when the reduction in the
objective is within this factor of the machine
tolerance. Default is 1e10, which gives a tolerance of about
\code{2e-6}, approximately 4 sigdigs.  You can check your
exact tolerance by multiplying this value by
\code{.Machine$double.eps}}

\item{eigen}{A boolean indicating if eigenvectors are calculated
to include a condition number calculation.}

\item{addPosthoc}{Boolean indicating if posthoc parameters are
added to the table output.}

\item{diagXform}{This is the transformation used on the diagonal
    of the \code{chol(solve(omega))}. This matrix and values are the
    parameters estimated in FOCEi. The possibilities are:

\itemize{
 \item \code{sqrt} Estimates the sqrt of the diagonal elements of \code{chol(solve(omega))}.  This is the default method.

 \item \code{log} Estimates the log of the diagonal elements of \code{chol(solve(omega))}

 \item \code{identity} Estimates the diagonal elements without any transformations
}}

\item{sumProd}{Is a boolean indicating if the model should change
multiplication to high precision multiplication and sums to
high precision sums using the PreciseSums package.  By default
this is \code{FALSE}.}

\item{optExpression}{Optimize the RxODE expression to speed up
calculation. By default this is turned on.}

\item{ci}{Confidence level for some tables.  By default this is
0.95 or 95\% confidence.}

\item{useColor}{Boolean indicating if focei can use ASCII color codes}

\item{boundTol}{Tolerance for boundary issues.}

\item{calcTables}{This boolean is to determine if the foceiFit
will calculate tables. By default this is \code{TRUE}}

\item{noAbort}{Boolean to indicate if you should abort the FOCEi
evaluation if it runs into troubles.  (default TRUE)}

\item{interaction}{Boolean indicate FOCEi should be used (TRUE)
instead of FOCE (FALSE)}

\item{cholSEtol}{tolerance for Generalized Cholesky
Decomposition.  Defaults to suggested (.Machine$double.eps)^(1/3)}

\item{cholAccept}{Tolerance to accept a Generalized Cholesky
Decomposition for a R or S matrix.}

\item{resetEtaP}{represents the p-value for reseting the
individual ETA to 0 during optimization (instead of the saved
value).  The two test statistics used in the z-test are either
chol(omega^-1) %%*%% eta or eta/sd(allEtas).  A p-value of 0
indicates the ETAs never reset.  A p-value of 1 indicates the
ETAs always reset.}

\item{diagOmegaBoundUpper}{This represents the upper bound of the
diagonal omega matrix.  The upper bound is given by
diag(omega)*diagOmegaBoundUpper.  If
\code{diagOmegaBoundUpper} is 1, there is no upper bound on
Omega.}

\item{diagOmegaBoundLower}{This represents the lower bound of the
diagonal omega matrix.  The lower bound is given by
diag(omega)/diagOmegaBoundUpper.  If
\code{diagOmegaBoundLower} is 1, there is no lower bound on
Omega.}

\item{cholSEOpt}{Boolean indicating if the generalized Cholesky
should be used while optimizing.}

\item{cholSECov}{Boolean indicating if the generalized Cholesky
should be used while calculating the Covariance Matrix.}

\item{fo}{is a boolean indicating if this is a fo approximation routine.}

\item{covTryHarder}{If the R matrix is non-positive definite and
cannot be corrected to be non-positive definite try estimating
the Hessian on the unscaled parameter space.}

\item{outerOpt}{optimization method for the outer problem}

\item{innerOpt}{optimization method for the inner problem (not
implemented yet.)}

\item{rhobeg}{Beginning change in parameters for bobyqa algorithm
(trust region).  By default this is 0.2 or 20% of the initial
parameters when the parameters are scaled to 1. rhobeg and
rhoend must be set to the initial and final values of a trust
region radius, so both must be positive with 0 < rhoend <
rhobeg. Typically rhobeg should be about one tenth of the
greatest expected change to a variable.  Note also that
smallest difference abs(upper-lower) should be greater than or
equal to rhobeg*2. If this is not the case then rhobeg will be
adjusted.}

\item{rhoend}{The smallest value of the trust region radius that
is allowed. If not defined, then 10^(-sigdig-1) will be used.}

\item{npt}{The number of points used to approximate the objective
function via a quadratic approximation for bobyqa. The value
of npt must be in the interval [n+2,(n+1)(n+2)/2] where n is
the number of parameters in par. Choices that exceed 2*n+1 are
not recommended. If not defined, it will be set to 2*n + 1}

\item{rel.tol}{Relative tolerance before nlminb stops.}

\item{x.tol}{X tolerance}

\item{eval.max}{Number of maximum evaluations of the objective function}

\item{iter.max}{Maximum number of iterations allowed.}

\item{abstol}{Absolute tolerance for nlmixr}

\item{reltol}{tolerance for nlmixr}

\item{resetHessianAndEta}{is a boolean representing if the
individual Hessian is reset when ETAs are reset using the
option \code{resetEtaP}.}

\item{stateTrim}{Trim state amounts/concentrations to this value.}

\item{...}{Ignored parameters}

\item{stiff}{a logical (\code{TRUE} by default) indicating whether
    the ODE system is stiff or not.

    For stiff ODE sytems (\code{stiff = TRUE}), \code{RxODE} uses the
    LSODA (Livermore Solver for Ordinary Differential Equations)
    Fortran package, which implements an automatic method switching
    for stiff and non-stiff problems along the integration
    interval, authored by Hindmarsh and Petzold (2003).

    For non-stiff systems (\code{stiff = FALSE}), \code{RxODE} uses
    DOP853, an explicit Runge-Kutta method of order 8(5, 3) of
    Dormand and Prince as implemented in C by Hairer and Wanner
    (1993).}
}
\description{
Control Options for FOCEi
}
\details{
Note this uses the R's L-BFGS-B in \code{\link{optim}} for the
outer problem and the BFGS \code{\link[n1qn1]{n1qn1}} with that
allows restoring the prior individual Hessian (for faster
optimization speed).

By default FOCEi scales the outer problem parameters to 1.0 for
the initial parameter estimates and scales the objective function
to 1.0, as suggested by the
\href{https://www.nag.com/numeric/fl/nagdoc_fl25/html/e04/e04intro.html}{NAG library}
and \href{scipy}{https://www.scipy-lectures.org/advanced/mathematical_optimization/}.

However the inner problem is not scaled.  Since most eta estimates
start near zero, scaling for these parameters do not make sense.

This process of scaling can fix some ill conditioning for the
unscaled problem.  The covariance step is performed on the
unscaled problem, so the condition number of that matrix may not
be reflective of the scaled problem's condition-number.
}
\seealso{
\code{\link{optim}}

\code{\link[n1qn1]{n1qn1}}

\code{\link[RxODE]{rxSolve}}
}
\author{
Matthew L. Fidler
}
