% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertEmax.R
\name{convertEmax}
\alias{convertEmax}
\title{Convert linear effect to Emax effect}
\usage{
convertEmax(
  ui,
  emax = "Emax",
  ec50 = "EC50",
  imax = "Imax",
  ic50 = "IC50",
  ek = c("Ik", "Ek"),
  cc = c("Ec", "Cc")
)
}
\arguments{
\item{ui}{rxode2 model}

\item{emax}{Emax parameter}

\item{ec50}{EC50 parameter}

\item{imax}{Imax parameter used when input model contains "Ik"
instead of "Ek"}

\item{ic50}{IC50 parameter used when input model contains "Ik"
instead of "Ek"}

\item{ek}{simulation linear constant}

\item{cc}{the concentration value}
}
\value{
Model with the linear effect converted to an Emax effect
}
\description{
Convert linear effect to Emax effect
}
\examples{

readModelDb("PK_2cmt_no_depot") |>
  addIndirectLin(stim="in") |>
  convertEmax()

# When emax=1
readModelDb("PK_2cmt_no_depot") |>
  addIndirectLin(stim="in") |>
  convertEmax(emax=1)

}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineConst}()},
\code{\link{addBaselineExp}()},
\code{\link{addBaselineLin}()},
\code{\link{addDirectLin}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
