% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX_MED.loading_helper.R
\name{getMIX_MED.loadings}
\alias{getMIX_MED.loadings}
\title{Get Factor Loadings for a Mixture Model or Multiple Group Model with Longitudinal Mediation Model with Specified Functional Curves as Submodels}
\usage{
getMIX_MED.loadings(
  nClass,
  t_var,
  y_var,
  m_var,
  x_var,
  x_type,
  curveFun,
  y_records,
  m_records,
  x_records = NULL
)
}
\arguments{
\item{nClass}{An integer specifying the number of classes for the mixture model or multiple group model. It takes the value passed
from \code{getMIX()} or \code{getMGroup()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time variable for the
corresponding longitudinal variable at each study wave. It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave. It takes the value
passed from \code{getMIX()} or \code{getMGroup()}.}

\item{m_var}{A string specifying the prefix of the column names corresponding to the mediator variable at each study wave.
It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{x_var}{A string specifying the baseline predictor if \code{x_type = "baseline"}, or the prefix of the column names
corresponding to the predictor variable at each study wave if \code{x_type = "longitudinal"}. It takes the value passed from \code{getMIX()}
or \code{getMGroup()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options include: "linear" (or "LIN"),
and "bilinear spline" (or "BLS"). It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{y_records}{A numeric vector specifying indices of the study waves for the outcome variable. It is the first vector
in \code{records} specified in \code{getMIX()} or \code{getMGroup()}.}

\item{m_records}{A numeric vector specifying indices of the study waves for the mediator variable. It is the second vector
in \code{records} specified in \code{getMIX()} or \code{getMGroup()}.}

\item{x_records}{A numeric vector specifying indices of the study waves for the predictor variable. Default value is \code{NULL},
which is for \code{x_type = "baseline"}. If \code{x_type = "longitudinal"}, it is the third vector in \code{records} specified in
\code{getMIX()} or \code{getMGroup()}.}
}
\value{
A list containing the specification of definition variables (i.e., individual measurement occasions) and factor
loadings of a longitudinal mediation model.
}
\description{
This function specifies the factor loadings for a mixture model with longitudinal mediation model with given functional
form as submodels
}
