% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_nls.R
\name{boot_nls}
\alias{boot_nls}
\title{Bootstrapping for nonlinear models}
\usage{
boot_nls(
  object,
  f = NULL,
  R = 999,
  psim = 2,
  resid.type = c("resample", "normal", "wild"),
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[stats]{nls}}}

\item{f}{function to be applied (and bootstrapped), default coef}

\item{R}{number of bootstrap samples, default 999}

\item{psim}{simulation level for \code{\link{simulate_nls}}}

\item{resid.type}{either \dQuote{resample}, \dQuote{normal} or \dQuote{wild}.}

\item{...}{additional arguments to be passed to function \code{\link[boot]{boot}}}
}
\description{
Bootstraping for nonlinear models
}
\details{
The residuals can either be generated by resampling with replacement 
(default or non-parametric), from a normal distribution (parameteric) or by changing 
their signs (wild). This last one is called \dQuote{wild bootstrap}. 
There is more information in \code{\link{boot_lm}}.
}
\examples{
\donttest{
require(car)
data(barley, package = "nlraa")
## Fit a linear-plateau
fit.nls <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)

## Bootstrap coefficients by default
fit.nls.bt <- boot_nls(fit.nls)
## Compute confidence intervals
confint(fit.nls.bt, type = "perc")
## Visualize
hist(fit.nls.bt, 1, ci = "perc", main = "Intercept")
hist(fit.nls.bt, 2, ci = "perc", main = "linear term")
hist(fit.nls.bt, 3, ci = "perc", main = "xs break-point term")
}

}
\seealso{
\code{\link[car]{Boot}}
}
