% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_nl.R
\name{import_nl}
\alias{import_nl}
\title{Import NetLogo Experiment}
\usage{
import_nl(tarfile, targetdir, new_session = FALSE)
}
\arguments{
\item{tarfile}{Path to tarfile that contains files to run NetLogo experiment}

\item{targetdir}{Path to folder where the experiments gets extracted}

\item{new_session}{If TRUE, opens a new RStudio Session with an Rproj}
}
\value{
The status value returned by the external command, invisibly.
}
\description{
Import NetLogo Experiment from export_nl
}
\details{
Imports NetLogo experiments that were saved with \code{export_nl}.
If the folder comes with an .Rproj file (which is recommended because
relative paths enhance the reproducability of your analysis),
\code{import_nl} opens this project and loads the nl object in your R environment.
}
\examples{
\dontrun{

infile <- "/home/user/test.zip"
targetdirectory <- "/home/user/test"
import_nl(infile, targetdirectory)
}
}
