% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_INLA_dat_pair.R
\name{create_INLA_dat_pair}
\alias{create_INLA_dat_pair}
\title{Prepare pairwise meta-analysis dataset for INLA.}
\usage{
create_INLA_dat_pair(ntrt, nctrl, ptrt, pctrl, cov = NULL)
}
\arguments{
\item{ntrt}{Number of subjects in treatment arm}

\item{nctrl}{Number of subjects in control arm}

\item{ptrt}{Number of events in treatment arm}

\item{pctrl}{Number of events in treatment arm}

\item{cov}{Optional argument to include a covariate in the model}
}
\value{
A list of two dataframe objects
}
\description{
\code{create_INLA_dat_pair} creates two dataframes, one to use in
a contrast based and the other in an arm-based pairwise meta-analysis.
}
\details{
The resulting data.frame can be used as data argument in
\code{meta_inla}.
}
\examples{
data('TBdat')
## Create the dataset suitable for INLA
TBdatINLA <- create_INLA_dat_pair(TBdat$TRT, TBdat$CON, TBdat$TRTTB, TBdat$CONTB)

## Check that the data are correct
print(TBdatINLA)
}
