\name{Blocks}
\docType{data}
\alias{Blocks}
\title{Blocks Data}
\description{
  the Blocks data, generally considered difficult for multiple change-points estimation due to highly heterogeneous segment levels and lengths, are generated by following codes:


n  <- 1000

k0 <- 11

cpt <- c(0.1,0.13,0.15,0.23,0.25,0.40,0.44,0.65,0.76,0.78,0.81)

cpm <- c(4.0,-5.0,3.0,-4.0,5.0,-4.2,2.1,4.3,-3.1,5.1,-4.2)

set.seed(1)

eps <- rt(n,3)

Blocks <- array(0,n)

for(j in 1:n){

  for(i in 1:11){

      if(j>(cpt[i]*n)) Blocks[j]<-sum(cpm[1:i])

    }
}

Blocks <- Blocks+eps

}
\usage{
data(Blocks)
}
\source{
Donoho, D. & Johnstone, I. (1995). Adapting to unknown smoothness via wavelet
shrinkage. J. Am.Statist. Assco. 90 1200-1224.
}
\format{vector}
\keyword{ datasets }
