% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000generate.R
\docType{data}
\name{MAEDtimeExpenditure}
\alias{MAEDtimeExpenditure}
\title{Time-use and expenditure dataset}
\format{
A data frame containing:
\describe{
  \item{PeID}{individual index}
  \item{PeGenF}{gender of the individual}
  \item{PeAge}{age in years}
  \item{PeEduc}{education level}
  \item{PeEmploy}{employment state}
  \item{HhCh}{type of household: with children or without children}
  \item{w}{hourly wage rate,  EUR/h}
  \item{I}{income not realted to work, EUR/week}
  \item{Tw}{time spent at work, h/week}
  \item{Tf1}{freely chosen activities group 1 (leisure), h/week}
  \item{Tf2}{freely chosen activities group 2 (eating, shopping, unspecified), h/week}
  \item{Tc}{time spent on committed activities (sleep, domestic work, personal care, travel, education, other), h/week}
  \item{Ef1}{freely chosen expenditure group 1 (leisure, accommodation, electronics), EUR/week}
  \item{Ef2}{freely chosen expenditure group 2 (clothes), EUR/week}
  \item{Ef3}{freely chosen expenditure group 3 (savings), EUR/week}
  \item{Ec}{committed expenditures (housing, food, mobility, insurance, other, services, health, furniture, education, financing), EUR/week}
  \item{ta}{total time budget = 168 h/week}
  \item{Td}{time spent on domestic chores, h/week. Td is part of Tc.}
}
}
\usage{
data(MAEDtimeExpenditure)
}
\description{
Data gathered in Austria in 2015 according to Mobility-Activity-Expenditure-Dairy (MAED), which reported all trips, activities (time use) and expenditures of 737 persons over a whole week
}
\details{
Time and expenditure data correspond to weekly totals. Time in hours and expenditure in EUR.

For more on data collection and description see \insertCite{aschauer2018}{nmm} and \insertCite{aschauer2015}{nmm}.

A variant of this dataset was used in:  \insertCite{schmid2017}{nmm},\insertCite{jokubauskaite2018}{nmm} and \insertCite{hoessinger2018}{nmm}.

To get the full dataset please contact r.hoessinger@boku.ac.at.
}
\examples{
data(MAEDtimeExpenditure)
}
\references{
\insertRef{aschauer2015}{nmm}

\insertRef{aschauer2018}{nmm}

\insertRef{hoessinger2018}{nmm}

\insertRef{jokubauskaite2018}{nmm}

\insertRef{schmid2017}{nmm}
}
\keyword{datasets}
