% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/006functions.R
\name{cont_stats}
\alias{cont_stats}
\title{Goodness of fit measures}
\usage{
cont_stats(
  x,
  which = c("all", "RMSE", "MAPE", "Rx2", "Rx2adj"),
  only_total = FALSE
)
}
\arguments{
\item{x}{Fitted \code{nmm} model.}

\item{which}{What to calculate. Options: "all", "RMSE", "MAPE", "Rx2", "Rx2adj".}

\item{only_total}{If \code{TRUE}, calculate statistics only for totals.}
}
\value{
matrix with Goodness of fit measures
}
\description{
Calculate RMSE, MAPE, R^2 and adjusted R^2
}
\examples{
library(systemfit)
data(ppine , package="systemfit")
hg.formula <- hg ~ exp( h0 + h1*log(tht) + h2*tht^2 + h3*elev)
dg.formula <- dg ~ exp( d0 + d1*log(dbh) + d2*hg + d3*cr)
labels <- list( "height.growth", "diameter.growth" )
model <- list( hg.formula, dg.formula )
start.values <- c(h0=-0.5, h1=0.5, h2=-0.001, h3=0.0001,
                  d0=-0.5, d1=0.009, d2=0.25, d3=0.005)
model.sur <- nlsystemfit( "SUR", model, start.values, data=ppine, eqnlabels=labels )
eq_c <- as.character(c(hg.formula, dg.formula))
parl <- c(paste0("h", 0:3),paste0("d", 0:3))
res <- nmm(ppine, eq_c=eq_c, start_v=start.values, par_c=parl,
eq_type = "cont", best_method = FALSE)
cont_stats(res, which = "all")
}
