% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.cv.nnGarrote.R
\name{coef.cv.nnGarrote}
\alias{coef.cv.nnGarrote}
\title{Coefficients for cv.nnGarrote Object}
\usage{
\method{coef}{cv.nnGarrote}(object, optimal.only = TRUE, ...)
}
\arguments{
\item{object}{An object of class cv.nnGarrote}

\item{optimal.only}{A boolean variable (TRUE default) to indicate if only the coefficient of the optimal split are returned.}

\item{...}{Additional arguments for compatibility.}
}
\value{
A matrix with the coefficients of the \code{cv.nnGarrote} object.
}
\description{
\code{coef.cv.nnGarrote} returns the coefficients for a cv.nnGarrote object.
}
\examples{
# Setting the parameters
p <- 500
n <- 100
n.test <- 5000
sparsity <- 0.15
rho <- 0.5
SNR <- 3
set.seed(0)
# Generating the coefficient
p.active <- floor(p*sparsity)
a <- 4*log(n)/sqrt(n)
neg.prob <- 0.2
nonzero.betas <- (-1)^(rbinom(p.active, 1, neg.prob))*(a + abs(rnorm(p.active)))
true.beta <- c(nonzero.betas, rep(0, p-p.active))
# Two groups correlation structure
Sigma.rho <- matrix(0, p, p)
Sigma.rho[1:p.active, 1:p.active] <- rho
diag(Sigma.rho) <- 1
sigma.epsilon <- as.numeric(sqrt((t(true.beta) \%*\% Sigma.rho \%*\% true.beta)/SNR))

# Simulate some data
x.train <- mvnfast::rmvn(n, mu=rep(0,p), sigma=Sigma.rho)
y.train <- 1 + x.train \%*\% true.beta + rnorm(n=n, mean=0, sd=sigma.epsilon)
x.test <- mvnfast::rmvn(n.test, mu=rep(0,p), sigma=Sigma.rho)
y.test <- 1 + x.test \%*\% true.beta + rnorm(n.test, sd=sigma.epsilon)

# Applying the NNG with Ridge as an initial estimator
\donttest{
nng.out <- cv.nnGarrote(x.train, y.train, intercept=TRUE,
                        initial.model=c("LS", "glmnet")[2],
                        lambda.nng=NULL, lambda.initial=NULL, alpha=0,
                        nfolds=5)
nng.predictions <- predict(nng.out, newx=x.test)
mean((nng.predictions-y.test)^2)/sigma.epsilon^2
}

# Ridge Regression
cv.ridge <- glmnet::cv.glmnet(x.train, y.train, alpha=0)
ridge <- glmnet::glmnet(x.train, y.train, alpha=0, lambda=cv.ridge$lambda.min)
ridge.predictions <- predict(ridge, newx=x.test)
mean((ridge.predictions-y.test)^2)/sigma.epsilon^2

# Comparisons of the coefficients
\donttest{
coef(nng.out)
}
coef(ridge)

}
\seealso{
\code{\link{cv.nnGarrote}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
