% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_clump.R
\name{raster_clump}
\alias{raster_clump}
\title{Wrapper for \code{raster::clump} on \code{stars} objects}
\usage{
raster_clump(x)
}
\arguments{
\item{x}{A \code{stars} object}
}
\value{
A \code{stars} object with the unique IDs for patches of connected cells that are not \code{0} or \code{NA}
}
\description{
This is a wrapper around \code{raster::clump}, to apply the function on \code{stars} objects without needing to convert to and from a \code{Raster*} object. (The function uses the \code{gaps=FALSE} setting.)
}
\examples{
library(stars)
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif)
r = r > 100
r_clump = raster_clump(r)
plot(r)
plot(r_clump)

}
