% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_azimuth.R
\name{st_azimuth}
\alias{st_azimuth}
\title{Calculate the azimuth between pairs of points}
\usage{
st_azimuth(x, y)
}
\arguments{
\item{x}{Object of class \code{sf}, \code{sfc} or \code{sfg}, of type \code{"POINT"}}

\item{y}{Object of class \code{sf}, \code{sfc} or \code{sfg}, of type \code{"POINT"}}
}
\value{
A \code{numeric} vector, of the same length as (the longer of) \code{x} and \code{y}, with the azimuth values from \code{x} to \code{y} (in decimal degrees, ranging between 0 and 360 clockwise from north). For identical points, an azimuth of \code{NA} is returned.
}
\description{
Calculates the (planar!) azimuth between pairs in two sequences of points \code{x} and \code{y}. When point sequence length doesn't match, the shorter one is recycled.
}
\note{
The function currently calculates planar azimuth, ignoring CRS information. For bearing on a sphere, given points in lon-lat, see function \code{geosphere::bearing}.
}
\examples{
# Two points
x = st_point(c(0, 0))
y = st_point(c(1, 1))
st_azimuth(x, y)

# Center and all other points on a 5*5 grid
library(stars)
m = matrix(1, ncol = 5, nrow = 5)
m[(nrow(m)+1)/2, (ncol(m)+1)/2] = 0
s = st_as_stars(m)
s = st_set_dimensions(s, 2, offset = ncol(m), delta = -1)
names(s) = "value"
pnt = st_as_sf(s, as_points = TRUE)
ctr = pnt[pnt$value == 0, ]
az = st_azimuth(ctr, pnt)
plot(st_geometry(pnt), col = NA)
plot(st_connect(ctr, pnt, k = nrow(pnt), progress = FALSE), col = "grey", add = TRUE)
plot(st_geometry(pnt), col = "grey", add = TRUE)
text(st_coordinates(pnt), as.character(round(az)), col = "red")
}
\references{
\url{https://en.wikipedia.org/wiki/Azimuth#Cartographical_azimuth}
}
