% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{varPseg.coeff}
\alias{varPseg.coeff}
\title{Variance of Pielou's Segregation Coefficient for 2 Classes}
\usage{
varPseg.coeff(ct, covN)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT}
}
\value{
The variance of Pielou's coefficient of segregation for the two-class case.
}
\description{
Returns the variance of Pielou's coefficient of segregation for the two-class case
(i.e., based on \eqn{2 \times 2} NNCTs)in a \eqn{2 \times 2} NNCT. 
This variance is valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat}) for more detail.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

varPseg.coeff(ct,covN)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

varPseg.coeff(ct,covN)

#############
ct<-matrix(sample(1:25,9),ncol=3)
#varPseg.coeff(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Pseg.coeff}}, \code{\link{seg.coeff}} and \code{\link{var.seg.coeff}}
}
\author{
Elvan Ceyhan
}
