% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.varNii}
\alias{funs.varNii}
\alias{varNii.ct}
\alias{varNii}
\title{Variances of the Self Entries in a Species Correspondence Contingency Table (SCCT)}
\usage{
varNii.ct(ct, Q, R)

varNii(dat, lab, ...)
}
\arguments{
\item{ct}{The NNCT or SCCT, used in \code{varNii.ct} only}

\item{Q}{The number of shared NNs, used in \code{varNii.ct} only}

\item{R}{The number of reflexive NNs (i.e., twice the number of reflexive NN pairs), used in \code{varNii.ct} only}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{varNii} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{varNii} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function, used in \code{varNii} only}
}
\value{
A \code{vector} of length \eqn{k} whose entries are the variances of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or of the diagonal entries in an NNCT.
}
\description{
Two functions: \code{varNii.ct} and \code{varNii}.

Both functions return a \code{vector} of length \eqn{k} of variances of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the variances of the diagonal entries \eqn{N_{ii}} in an NNCT,
but have different arguments (see the parameter list below).
These variances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

The argument \code{ct} which is used in \code{varNii.ct} only, can be either the NNCT or SCCT.

See also (\insertCite{ceyhan:NNCorrespond2018;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

varNii(Y,cls)
varNii.ct(ct,Qv,Rv)

varNii(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

varNii(Y,fcls)
varNii.ct(ct,Qv,Rv)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

varNii(Y,cls)
varNii.ct(ct,Qv,Rv)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{scct}}, \code{\link{var.nnct}}, \code{\link{var.tct}}, \code{\link{var.nnsym}}
and \code{\link{covNii}}
}
\author{
Elvan Ceyhan
}
