% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsXsq.nnsym.dx}
\alias{funsXsq.nnsym.dx}
\alias{Xsq.nnsym.dx.ct}
\alias{Xsq.nnsym.dx}
\title{Dixon's NN Symmetry Test with Chi-square Approximation for multiple classes}
\usage{
Xsq.nnsym.dx.ct(ct, covS)

Xsq.nnsym.dx(dat, lab, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Xsq.nnsym.dx.ct} only}

\item{covS}{The \eqn{k(k-1)/2 \times k(k-1)/2} covariance matrix of the differences of the off-diagonal entries in the NNCT,
\code{ct}, usually the output of the function \code{\link{cov.nnsym}}.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Xsq.nnsym.dx} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Xsq.nnsym.dx} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Xsq.nnsym.dx} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for Dixon's overall NN symmetry test}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)/2} for this function.}
\item{estimate}{Estimates, i.e., absolute differences of the off-diagonal entries of 
NNCT (in the upper-triangular form).}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null values for the differences between the expected values of the off-diagonal 
entries, which is 0 for this function.}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Xsq.nnsym.dx.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Xsq.nnsym.dx} only}
}
\description{
Two functions: \code{Xsq.nnsym.dx.ct} and \code{Xsq.nnsym.dx}.

Both functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs the hypothesis test of equality of the expected value of the off-diagonal 
cell counts (i.e., entries) under RL or CSR in the NNCT for \eqn{k \ge 2} classes.
That is, each performs Dixon's overall NN symmetry test.
The test is appropriate (i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

Each symmetry test is based on the chi-squared approximation of the corresponding quadratic form
and is an extension of Dixon's NN symmetry test, which is extended by
\insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)/2}, description of the 
alternative with the corresponding null values (i.e. expected values) of differences of the off-diagonal entries,(which is
0 for this function) and also the sample estimates (i.e. observed values) of absolute differences of the off-diagonal entries of 
NNCT (in the upper-triangular form).
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that all \eqn{E(N_{ij})=E(N_{ji})} entries for all \eqn{i \ne j} (i.e., symmetry in the 
mixed NN structure).

See also
(\insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow
covS<-cov.nnsym(covN)

Xsq.nnsym.dx(Y,cls)
Xsq.nnsym.dx.ct(ct,covS)

Xsq.nnsym.dx(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Xsq.nnsym.dx(Y,fcls)
Xsq.nnsym.dx.ct(ct,covS)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)
covS<-cov.nnsym(covN)

Xsq.nnsym.dx(Y,cls)
Xsq.nnsym.dx.ct(ct,covS)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym.dx.ct}}, \code{\link{Znnsym.dx}}, \code{\link{Znnsym}},
\code{\link{Xsq.nnsym}}, \code{\link{Xsq.nnsym.ss.ct}}, \code{\link{Xsq.nnsym.ss}}
and \code{\link{Qsym.test}}
}
\author{
Elvan Ceyhan
}
