% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{ind.nnsym}
\alias{ind.nnsym}
\title{Index Matrix for Computing the Covariance of Dixon's Overall NN Symmetry Test}
\usage{
ind.nnsym(k)
}
\arguments{
\item{k}{An integer specifying the number of classes in the data set}
}
\value{
The \eqn{k(k-1)/2 \times 2} index matrix with each row is the \eqn{i,j} 
corresponding to \eqn{N_{ij}} in the NNCT
}
\description{
Returns the index matrix for choosing the entries in the covariance matrix for NNCT 
used for computing the covariance for Dixon's NN symmetry test.
The matrix is \eqn{k(k-1)/2 \times 2} with each row is the \eqn{i,j} 
corresponding to \eqn{N_{ij}} in the NNCT.
}
\seealso{
\code{\link{cov.nnsym}} and \code{\link{ind.seg.coeff}}
}
\author{
Elvan Ceyhan
}
