% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{nnct.sub}
\alias{nnct.sub}
\title{Nearest Neighbor Contingency Table (NNCT) with (only) base points restricted to a subsample}
\usage{
nnct.sub(ss, x, lab, ties = FALSE, is.ipd = TRUE, ...)
}
\arguments{
\item{ss}{indices of subjects (i.e., row indices in the data set) chosen to be the base points}

\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{ties}{A logical argument (default=\code{FALSE}) to take ties into account or not. If \code{TRUE} a NN 
contributes \eqn{1/m} to the NN count if it is one of the \eqn{m} tied NNs of a subject.}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{...}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the \eqn{k \times k} NNCT where \eqn{k} is the number of classes in the data set with (only) base points
restricted to a subsample \code{ss}.
}
\description{
Returns the \eqn{k \times k} NNCT with (only) base points are restricted to be in the subset of indices \code{ss} using
the IPD matrix or data set \code{x} where \eqn{k} is the number of classes in the data set. That is, the base points
are the points with indices in \code{ss} but for the NNs the function checks all the points in the data set 
(including the points in \code{ss}). 
Row and columns of the NNCT are labeled with the corresponding class labels.

The argument \code{ties} is a logical argument (default=\code{FALSE}) to take ties into account or not. If \code{TRUE} a NN 
contributes \eqn{1/m} to the NN count if it is one of the \eqn{m} tied NNs of a subject.

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
nnct(ipd,cls)

#subsampling indices
ss<-sample(1:n,floor(n/2))
nnct.sub(ss,ipd,cls)
nnct.sub(ss,Y,cls,is.ipd = FALSE)
nnct.sub(ss,ipd,cls,ties = TRUE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
nnct.sub(ss,ipd,fcls)

#cls as an unsorted factor
fcls<-sample(c("a","b"),n,replace = TRUE)
nnct(ipd,fcls)
nnct.sub(ss,ipd,fcls)

fcls<-sort(fcls)
nnct.sub(ss,ipd,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ss<-sample(1:40,30)
nnct.sub(ss,ipd,cls)

#cls as a factor
fcls<-rep(letters[1:4],rep(10,4))
nnct.sub(ss,ipd,cls)

#1D data points
n<-20  #or try sample(1:20,1)
X<-as.matrix(runif(n))# need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
nnct(ipd,cls)

#subsampling indices
ss<-sample(1:n,floor(n/2))
nnct.sub(ss,ipd,cls)

#with possible ties in the data
Y<-matrix(round(runif(120)*10),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ss<-sample(1:40,30)
nnct.sub(ss,ipd,cls)
nnct.sub(ss,ipd,cls,ties = TRUE)

}
\seealso{
\code{\link{nnct}} and \code{\link{nnct.boot.dis}}
}
\author{
Elvan Ceyhan
}
