% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{docdb_update}
\alias{docdb_update}
\title{Update documents}
\usage{
docdb_update(src, key, value, ...)
}
\arguments{
\item{src}{source object, result of call to src}

\item{key}{(character) A key (collection for MongoDB and
RSQLite)}

\item{value}{(data.frame) A single data.frame. For
MongoDB and RSQLite, its first column identifies the
documents to be updated by means of the name of the
column and the value(s) in the respective row(s),
see examples.}

\item{...}{Ignored}
}
\description{
Update documents
}
\details{
Only CouchDB and sqlite supported for now
}
\examples{
\dontrun{
# CouchDB
src <- src_couchdb()
docdb_create(src, "mtcars2", mtcars)
docdb_get(src, "mtcars2")

mtcars$letter <- sample(letters, NROW(mtcars), replace = TRUE)
invisible(docdb_update(src, "mtcars2", mtcars))
docdb_get(src, "mtcars2")

# MongoDB
src <- src_mongo(collection = "mtcars")
docdb_create(src, key = "mtcars", value = mtcars)
# - update of carb for each matching gear
value <- data.frame("gear" = c(4, 5),
                    "carb" = c(8.1, 7.9),
                    stringsAsFactors = FALSE)
docdb_update(src, "mtcars", value)
# - update of gear where _id / oid is "2"
value <- data.frame("_id" = "2",
                    "gear" = 9,
                    stringsAsFactors = FALSE,
                    check.names = FALSE)
docdb_update(src, "mtcars", value)
docdb_get(src, "mtcars")

# SQLite
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
dfupd <- data.frame("cyl" = c(4, 6),
                    "gear" = c(88, 99),
                    stringsAsFactors = FALSE)
(docdb_update(src, "mtcars", dfupd))
docdb_query(src, "mtcars",
            query = '{"gear": {"$gte": 88}}',
            fields = '{"gear": 1, "cyl": 1}')
dfupd <- data.frame("cyl" = c(8, 6),
                    "somejson" = c('{"gear": 77, "carb": 55}',
                                   '{"gear": 66, "newvar": 55}'),
                    stringsAsFactors = FALSE)
(docdb_update(src, "mtcars", dfupd))
docdb_query(src, "mtcars",
            query = '{"gear": {"$eq": 66}}',
            fields = '{"gear": 1, "cyl": 1, "carb": 1, "newvar": 1}')
}
}
