% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-fn-aware.R
\name{make_fn_aware}
\alias{make_fn_aware}
\title{Make a function aware of abbreviated functional arguments}
\usage{
make_fn_aware(f, ...)
}
\arguments{
\item{f}{Function, or symbol or name of a function.}

\item{...}{Name(s) of functional argument(s) of \code{f} (strings) or \code{NULL}.
Unsplicing of lists of strings is supported via \verb{!!!}.}
}
\value{
A function with the same call signature as \code{f}, but whose function
arguments, as designated by \code{...}, may be specified using an abbreviated
function expression of the form \code{.(...)}, cf. \code{\link[=as_fn]{as_fn()}}. If \code{...} is empty
or \code{NULL}, then \code{f} is simply returned.
}
\description{
\code{make_fn_aware()} is a functional operator that enhances a function by
enabling it to interpret abbreviated functional arguments.
}
\examples{
reduce <- make_fn_aware(Reduce, "f")

## reduce() behaves just like Reduce()
Reduce(function(u, v) u + 1 / v, c(3, 7, 15, 1, 292), right = TRUE)
reduce(function(u, v) u + 1 / v, c(3, 7, 15, 1, 292), right = TRUE)

## reduce() can also interpret abbreviated function expressions
reduce(.(u, v ~ u + 1 / v), c(3, 7, 15, 1, 292), right = TRUE)

}
\seealso{
\code{\link[=as_fn]{as_fn()}}
}
