% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/good3.R
\name{good3}
\alias{good3}
\title{Goodall 3 Measure}
\usage{
good3(data)
}
\arguments{
\item{data}{data frame with cases in rows and variables in colums. Cases are characterized by nominal (categorical) variables coded as numbers.}
}
\value{
Function returns a matrix of the size \code{n x n}, where \code{n} is the number of objects in original data. The matrix contains proximities
between all pairs of objects. It can be used in hierarchical cluster analyses (HCA), e.g. in \code{\link[cluster]{agnes}}.
\cr
}
\description{
The Goodall 3 similarity measure was firstly introduced in (Boriah et al., 2008).           
The measure assigns higher similarity if the infrequent categories match
regardless on frequencies of other categories.
Hierarchical clustering methods require a proximity (dissimilarity) matrix instead of a similarity matrix as
an entry for the analysis; therefore, dissimilarity \code{D} is computed from similarity \code{S} according the equation
\code{1/S-1}.\cr
\cr                                                                   
The use and evaluation of clustering with this measure can be found e.g. in (Sulc, 2015).
}
\examples{
#sample data
data(data20)
# Creation of proximity matrix
prox_goodall_3 <- good3(data20)

}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
\references{
Boriah, S., Chandola and V., Kumar, V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254. Available at:
\url{ http://www-users.cs.umn.edu/~sboriah/PDFs/BoriahBCK2008.pdf}.
\cr
\cr
Goodall, V.D. (1966). A new similarity index based on probability. Biometrics, 22(4), p. 882.
\cr
\cr
Sulc, Z. (2015). Application of Goodall's and Lin's similarity measures in hierarchical clustering.
In Sbornik praci vedeckeho seminare doktorskeho studia FIS VSE. Praha: Oeconomica, 2015, p. 112-118. Available at:
\url{http://fis.vse.cz/wp-content/uploads/2015/01/DD_FIS_2015_CELY_SBORNIK.pdf}.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{morlini}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}

