% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vm.R
\name{vm}
\alias{vm}
\title{Variable Mutability measure}
\usage{
vm(data)
}
\arguments{
\item{data}{data frame or matrix with cases in rows and variables in colums. Cases are characterized by nominal (categorical) variables coded as numbers.}
}
\value{
Function returns a matrix of the size \code{n x n}, where \code{n} is the number of objects in original data. The matrix contains proximities
between all pairs of objects. It can be used in hierarchical cluster analyses (HCA), e.g. in \code{\link[cluster]{agnes}}.
\cr
}
\description{
The Variable Mutability similarity measure was introduced in (Sulc and Rezankova, 2015).
It treats similarity between two categories according to within-cluster variability expressed by the Gini coefficient (mutability).
The novel similarity measures praise more the match of two categories in a variable with high variability, because it is rarer,
than the match in a low-variability variable.
Hierarchical clustering methods require a proximity (dissimilarity) matrix instead of a similarity matrix as
an entry for the analysis; therefore, dissimilarity \code{D} is computed from similarity \code{S} according the equation
\code{1/S-1}.\cr
\cr
}
\examples{
#sample data
data(data20)
# Creation of proximity matrix
prox_vm <- vm(data20)

}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
\references{
Sulc, Z. and Rezankova H. (2015). Novel similarity measures for categorical data based on mutability and entropy.
 Conference of the International Federation of Classification Societies. Bologna: Ospitalia, p. 209.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{morlini}}, 
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}}.
}

