% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/good2.R
\name{good2}
\alias{good2}
\title{Goodall 2 (G2) Measure}
\usage{
good2(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns an object of class "dist".
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the G2 similarity measure.
}
\details{
The Goodall 2 similarity measure was presented in (Boriah et al., 2008). It is a simple modification of the original Goodall measure (Goodall, 1966).                         
The measure assigns weight to infrequent matches under the condition that there are also other categories, which are even less frequent than the examined one.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.good2 <- good2(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Goodall V.D. (1966). A new similarity index based on probability. Biometrics, 22(4), p. 882.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
