% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite.R
\name{reverse_geo_lite}
\alias{reverse_geo_lite}
\title{Reverse Geocoding API for OSM objects}
\usage{
reverse_geo_lite(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  custom_query = list()
)
}
\arguments{
\item{lat}{latitude values in numeric format. Must be in the range
\verb{[-90, 90]}.}

\item{long}{longitude values in numeric format. Must be in the range
\verb{[-180, 180]}.}

\item{address}{address column name in the output data (default  \code{"address"}).}

\item{full_results}{returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_coords}{return input coordinates with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See \strong{Details}.}
}
\value{
A \code{tibble} with the results.
}
\description{
Generates an address from a latitude and longitude. Latitudes must be
between \verb{[-90, 90]} and longitudes between \verb{[-180, 180]}. This
function returns the \CRANpkg{tibble} associated with the query, see
\code{\link[=reverse_geo_lite_sf]{reverse_geo_lite_sf()}} for retrieving the data as a spatial object
(\CRANpkg{sf}) format).
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Zooming}{


Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{rl}{
   \strong{zoom} \tab \strong{address_detail} \cr
   3 \tab country \cr
   5 \tab state \cr
   8 \tab county \cr
   10 \tab city \cr
   14 \tab suburb \cr
   16 \tab major streets \cr
   17 \tab major and minor streets \cr
   18 \tab building \cr
}
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

reverse_geo_lite(lat = 40.75728, long = -73.98586)

# Several coordinates
reverse_geo_lite(lat = c(40.75728, 55.95335), long = c(-73.98586, -3.188375))

# With options: zoom to country level
sev <- reverse_geo_lite(
  lat = c(40.75728, 55.95335), long = c(-73.98586, -3.188375),
  custom_query = list(zoom = 0, extratags = 1),
  verbose = TRUE, full_results = TRUE
)

dplyr::glimpse(sev)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reverse_geo_lite_sf]{reverse_geo_lite_sf()}}, \code{\link[tidygeocoder:reverse_geo]{tidygeocoder::reverse_geo()}}

Reverse geocoding coordinates: 
\code{\link{reverse_geo_lite_sf}()}
}
\concept{reverse}
