% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gender.r
\name{get_gender}
\alias{get_gender}
\title{Classifies names based on gender}
\usage{
get_gender(given, family, secret, user)
}
\arguments{
\item{given}{A vector of given names (i.e. first names).}

\item{family}{A vector of family names (i.e. surnames or last names).}

\item{secret}{A NameSor API Key (Secret). This is typically a long string of mixed-case letters and numbers.}

\item{user}{A NameSor API Channel (User). This string contains 'namsor.com', the email address used to register for API access, and a vector of numbers.}
}
\value{
An object that classifies inputted names according to gender.
}
\description{
Returns an object that classifies inputted names according to gender.
}
\examples{
\dontrun{
first_name <- c("Volha", "Charles", "Donald")
last_name <- c("Chykina", "Crabtree", "Duck")

Note that the vectors of first and last names should be the same length.
Future versions of the package will deal with differing lengths.

key <- "45b2kjsskd2335435kkmfdksmfkko"
channel <- "namsor.com/email@domain.com/111111"
y <- get_gender(first_name, last_name, key, channel)
y
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
