% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nonLinearSystems.R
\name{ikedaMap}
\alias{ikedaMap}
\title{Ikeda map}
\usage{
ikedaMap(a = 0.85, b = 0.9, cc = 7.7, k = 0.4, start = runif(2),
  n.sample = 5000, n.transient = 500, do.plot = TRUE)
}
\arguments{
\item{a}{The \emph{a} parameter. Default: 0.85.}

\item{b}{The \emph{b} parameter. Default: 0.9.}

\item{cc}{The \emph{c} parameter. Default: 7.7.}

\item{k}{The \emph{k} parameter. Default: 0.4.}

\item{start}{a 2-dimensional numeric vector indicating the starting value for the time series.
If the starting point is not specified, it is generated randomly.}

\item{n.sample}{Length of the generated time series. Default: 5000 samples.}

\item{n.transient}{Number of transient samples that will be discarded. Default: 500 samples.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the generated ikeda system is shown.}
}
\value{
a list with 2 vectors named \emph{x} and \emph{y} the x-components and the
y-components of the Ikeda map, respectively.
}
\description{
Generates a time series using the Ikeda map
}
\details{
The Ikeda map is defined as follows:
\deqn{z_{n+1} = a + b \cdot z_n \cdot exp( ik-\frac{ic}{( 1+ |z_{n-1}|^2  )} )}{z[n+1] = a + b*z[n]*exp(ik-ic/( 1+ |z_[n-1]|^2  ) )}
The default selection for the \emph{a}, \emph{b}, \emph{c} and \emph{k} parameters is known to
produce a deterministic chaotic time series.
}
\note{
Some initial values may lead to an unstable system that will tend to infinity.
}
\examples{
\dontrun{
ikeda.map=ikedaMap(n.sample = 1000, n.transient=10, do.plot=TRUE)
}
}
\author{
Constantino A. Garcia
}
\references{
Strogatz, S.: Nonlinear dynamics and chaos: with applications to physics, biology, chemistry and engineering (Studies in Nonlinearity)
}
\seealso{
\code{\link{henon}, \link{logisticMap}, \link{lorenz}, \link{rossler}, \link{cliffordMap}, \link{sinaiMap}, \link{gaussMap}}
}

