% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadNonmemOutput.R
\name{extToTable}
\alias{extToTable}
\title{Compile parameter table suitable for reports}
\usage{
extToTable(model, use.model.path = TRUE, tableType = 2, wide = TRUE,
  format.estimate = "\% -#6.4g", format.rse = "\%#6.3g")
}
\arguments{
\item{model}{name of the ext file with or without the .ext extension.
model may include full or relative path to the ext file. See examples.}

\item{use.model.path}{Load file from a global defined model library (TRUE=default).
If so will look for a global character vector named \code{model.path}}

\item{tableType}{Table type for THETA's, OMEGA's and SIGMA's

tableType=0: Present OMEGA and SIGMA as variance and covariances and display SE for THETA, OMEGA, SIGMA

tableType=1: Present OMEGA and SIGMA as variance and covariances and display RSE for THETA, OMEGA, SIGMA

tableType=2: Present OMEGA and SIGMA as standard-deviation and correlations and display RSE for THETA, OMEGA, SIGMA

tableType=3: Present OMEGA and SIGMA as standard-deviation and correlations and display SE for THETA, OMEGA, SIGMA}

\item{wide}{produce a wide 9-column table (wide=TRUE, default) or a thin 3-column table(wide=FALSE)}

\item{format.estimate}{format for estimated value, passed to sprintf}

\item{format.rse}{format for rse, passed to sprintf}
}
\value{
a character-matrix
}
\description{
Load parameter values from a nonmem .ext output file and compile to table suitable for reports.
Format can be "wide" (wide=TRUE, default) with a similar look as from sumoR,
or similar a 3 column layout (wide=FALSE).
}
\examples{
##### Load the .ext file "run001.ext"
# 1) Get path to the example file included in nonmem2R package
file1 <- system.file("extdata", "run001.ext", package = "nonmem2R")
# 2) Load the file using the extload function
extToTable(file1)

}
